#pragma rtGlobals=1		// Use modern global access method.
#include "mafITC"
#include "mafPC"

// Improvements to be made
// *	Store pattern data in result wave
// *	Implement dynamic clamp

menu "Acquisition"
	"Run Pattern", /Q, mafPC_ITC_RunMenu ()
	"Compile Pattern", /Q, mafPC_ITC_CompileMenu ()
	"Verify Pattern", /Q, mafPC_ITC_VerifyMenu ()
	"-"
end

function mafPC_ITC_Run (patname, parameterlist)
	string patname, parameterlist
	svar currpat = $("root:maf:" + patname)
	string da1, da2, ttl, force, con1, con2
	
	mafPC_ITC_Compile (patname, parameterlist)
	if (numberbykey ("DYNAMICCLAMP", currPat) == 1)
		mafITC_newDoDynamicClamp ("root:maf:" + patname, stringbykey ("CONTROL", currpat), stringbykey ("SAVECHAN", currpat), numberbykey ("DCVREV1", currPat), numberbykey ("DCVREV2", currPat), "PATTERN:" + patname + selectstring (strlen (parameterlist) > 0, "", ";" + parameterlist))
	else
		mafITC_Stim ("root:maf:" + patname, bits2Seq (stringbykey ("CONTROL", currpat)), bits2seq (stringbykey ("SAVECHAN", currpat)), "PATTERN:" + patname + selectstring (strlen (parameterlist) > 0, "", ";" + parameterlist))
	endif
end

function mafPC_ITC_Compile (patname, parameterlist)
	string patname, parameterlist
	variable i
	SVAR currpat = $("root:maf:" + patname)
	string control = replacestring (",", stringbykey ("CONTROL", currPat), ";"), ch
	
	// append current hp's to parameter list
	for (i = 0; i < itemsinlist (control); i += 1)
		if (cmpstr ((stringfromlist (i, control))[0,1], "DA") == 0)
			ch = thischannum (i, control)
			parameterlist = replacenumberbykey ("HP" + ch, parameterlist, mafITC_GetHP (str2num (ch)))
		endif
	endfor
	return (mafPC_CompilePattern (patname, parameterlist))
end

function mafPC_ITC_RunMenu()
	variable tempval
	NVAR mafPC_userResponse=root:maf:mafPC_userResponse
	wave /t mafPC_Patterns=root:maf:mafPC_Patterns
	string params
	
	tempval = checkval ("patlist", "mafPC_PatternPanel")
	if (tempval >= 0 && tempval < numpnts (mafPC_Patterns))
		params = mafPC_EnterParameters (mafPC_Patterns[tempval])
		if (mafPC_userResponse == 1)
			mafPC_ITC_Run (mafPC_Patterns[tempval], params)
		endif
	endif
end
function mafPC_ITC_CompileMenu()
	variable tempval
	NVAR mafPC_userResponse=root:maf:mafPC_userResponse
	wave /t mafPC_Patterns=root:maf:mafPC_Patterns
	string params
	
	tempval = checkval ("patlist", "mafPC_PatternPanel")
	if (tempval >= 0 && tempval < numpnts (mafPC_Patterns))
		params = mafPC_EnterParameters (mafPC_Patterns[tempval])
		if (mafPC_userResponse == 1)
			mafPC_ITC_Compile (mafPC_Patterns[tempval], params)
		endif
	endif
end
function mafPC_ITC_VerifyMenu()
	wave /t mafPC_Patterns=root:maf:mafPC_Patterns
	variable tempval
	tempval = checkval ("patlist", "mafPC_PatternPanel")
	if (tempval >= 0 && tempval < numpnts (mafPC_Patterns))
		SVAR currPat=$("root:maf:" + mafPC_Patterns[tempval])
		if (numberbykey ("COMPILED", currPat) != 1)	// first get it compiled
			mafPC_ITC_CompileMenu()
		endif
		if (numberbykey ("COMPILED", currPat) == 1)		
			mafPC_VerifyCompile (mafPC_Patterns[tempval])
		else
			doalert 0, "Pattern must be compiled before verifying."
		endif
	endif
end